/*
 * Copyright (c)  2015~2025, Xforceplus
 * All rights reserved.
 * Project: tenant-service
 * ClassName: GradingRoleDTO   
 * Date: 2021-08-31 09:51:21
 * Author: zhouxin
 */
package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @Description: 
 * @CopyRight: 上海云砺信息科技有限公司
 * @Author: zhouxin
 * @Email: yf_zhouxin@xforceplus.com
 * @Date: 2021/8/31 09:51:21
 */
@Getter
@Setter
@ToString
@SuppressWarnings("all")
public class GradingRoleDTO extends RoleDto implements Serializable {

    @JsonView(RoleView.class)
    @ApiModelProperty(value = "可用组织角色数")
    private Long orgRoleCnt;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty(value = "被授予的用户列表")
    private List<GradingRoleUser> users = new ArrayList<>();

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty(value = "被关联的组织列表")
    private List<GradingRoleOrg> orgs = new ArrayList<>();

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("功能集集合")
    protected Map<Long, List<ResourcesetDto>> resourcesetMap = new HashMap<>();

}
