/*
 * Copyright (c)  2015~2025, Xforceplus
 * All rights reserved.
 * Project: tenant-service
 * ClassName: GradingRoleORg   
 * Date: 2021-08-31 17:38:15
 * Author: zhouxin
 */
package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @Description: 
 * @CopyRight: 上海云砺信息科技有限公司
 * @Author: zhouxin
 * @Email: yf_zhouxin@xforceplus.com
 * @Date: 2021/8/31 17:38:15
 */
@Setter
@Getter
@ToString
public class GradingRoleOrg implements Serializable {

    public GradingRoleOrg() {
    }

    public GradingRoleOrg(Long orgId, Long roleId, String orgName) {
        this.orgId = orgId;
        this.roleId = roleId;
        this.orgName = orgName;
    }

    @ApiModelProperty(value = "组织id")
    @JsonView(RoleView.RoleInfo.class)
    private Long orgId;

    @ApiModelProperty(value = "角色id")
    @JsonView(RoleView.RoleInfo.class)
    private Long roleId;

    @ApiModelProperty(value = "组织名称")
    @JsonView(RoleView.RoleInfo.class)
    private String orgName;

}
