/*
 * Copyright (c)  2015~2025, Xforceplus
 * All rights reserved.
 * Project: tenant-service
 * ClassName: GradingRoleUser   
 * Date: 2021-08-31 17:37:43
 * Author: zhouxin
 */
package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @Description: 
 * @CopyRight: 上海云砺信息科技有限公司
 * @Author: zhouxin
 * @Email: yf_zhouxin@xforceplus.com
 * @Date: 2021/8/31 17:37:43
 */
@Setter
@Getter
@ToString
public class GradingRoleUser implements Serializable {

    public GradingRoleUser() {
    }

    public GradingRoleUser(String userName, String userPhone, String userEmail) {
        this.userName = userName;
        this.userPhone = userPhone;
        this.userEmail = userEmail;
    }

    @ApiModelProperty(value = "用户姓名")
    @JsonView(RoleView.RoleInfo.class)
    private String userName;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty(value = "用户手机号码")
    private String userPhone;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty(value = "用户邮箱")
    private String userEmail;

}