/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.tenant.security.core.domain.OrgType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgUtils {
    private static final Logger logger = LoggerFactory.getLogger(OrgUtils.class);

    public static Set<Long> findOrgIdInParentIds(String parentIds) {
        if (StringUtils.isBlank((CharSequence)parentIds)) {
            return Collections.emptySet();
        }
        logger.debug("parentIds = " + parentIds);
        String pattern = "(\\d+)" + Arrays.stream(OrgType.values()).map(OrgType::separator).collect(Collectors.joining("|", "[", "]"));
        logger.debug("pattern = " + pattern);
        Matcher matcher = Pattern.compile(pattern).matcher(parentIds);
        HashSet<Long> parentOrgIds = new HashSet<Long>();
        while (matcher.find()) {
            String group = matcher.group(1);
            try {
                Long orgId = Long.parseLong(group);
                parentOrgIds.add(orgId);
            }
            catch (NumberFormatException e) {
                String message = e.getMessage() + ", value: " + group;
                logger.warn(message);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("parentOrgIds = " + parentOrgIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        return parentOrgIds;
    }

    public static Set<Long> findCompanyOrgIdsInParentIds(String parentIds) {
        logger.debug("parentIds = " + parentIds);
        String pattern = "(\\d+)" + OrgType.COMPANY.separator();
        logger.debug("pattern = " + pattern);
        Matcher matcher = Pattern.compile(pattern).matcher(parentIds);
        HashSet<Long> companyOrgIds = new HashSet<Long>();
        while (matcher.find()) {
            String group = matcher.group(1);
            try {
                long companyOrgId = Long.parseLong(group);
                companyOrgIds.add(companyOrgId);
                if (!logger.isInfoEnabled()) continue;
                logger.info("companyOrgId = " + companyOrgId);
            }
            catch (NumberFormatException e) {
                String message = e.getMessage() + ", value: " + group;
                logger.warn(message);
            }
        }
        return companyOrgIds;
    }

    public static Long findRootIdInParentIds(String parentIds) {
        logger.debug("parentIds = " + parentIds);
        String pattern = "(\\d+)" + OrgType.GROUP.separator();
        logger.debug("pattern = " + pattern);
        Matcher matcher = Pattern.compile(pattern).matcher(parentIds);
        Long rootId = null;
        while (matcher.find()) {
            String group = matcher.group(1);
            try {
                rootId = Long.parseLong(group);
            }
            catch (NumberFormatException e) {
                String message = e.getMessage() + ", value: " + group;
                logger.warn(message);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("rootId = " + rootId);
        }
        return rootId;
    }

    public static Set<String> compressParentIdsCollection(Collection<String> parentIdsCollection) {
        if (parentIdsCollection == null) {
            return Collections.emptySet();
        }
        if (parentIdsCollection.isEmpty()) {
            if (parentIdsCollection instanceof Set) {
                return (Set)parentIdsCollection;
            }
            return Collections.emptySet();
        }
        Stack parentIdsStack = new Stack();
        parentIdsCollection.stream().filter(StringUtils::isNotBlank).sorted(String::compareTo).forEach(currentParentIds -> {
            if (parentIdsStack.isEmpty()) {
                parentIdsStack.push(currentParentIds);
            } else {
                String parentIds = (String)parentIdsStack.pop();
                if (!parentIds.equals(currentParentIds)) {
                    if (parentIds.startsWith((String)currentParentIds)) {
                        parentIdsStack.push(currentParentIds);
                    } else if (currentParentIds.startsWith(parentIds)) {
                        parentIdsStack.push(parentIds);
                    } else {
                        parentIdsStack.push(parentIds);
                        parentIdsStack.push(currentParentIds);
                    }
                } else {
                    parentIdsStack.push(parentIds);
                }
            }
        });
        return parentIdsStack.stream().collect(Collectors.toSet());
    }

    public static Set<Long> excludeInParentIds(Collection<Long> orgIds, Collection<String> parentIdsCollection) {
        if (orgIds == null) {
            return Collections.emptySet();
        }
        Set<Long> filteredOrgIds = orgIds instanceof Set ? (HashSet<Long>)orgIds : new HashSet<Long>(orgIds);
        if (CollectionUtils.isEmpty(filteredOrgIds)) {
            return filteredOrgIds;
        }
        if (CollectionUtils.isEmpty(parentIdsCollection)) {
            return filteredOrgIds;
        }
        for (String parentIds : parentIdsCollection) {
            String filterParentIdsWithoutLastSperator = StringUtils.substring((String)parentIds, (int)0, (int)(parentIds.length() - 1));
            filteredOrgIds = filteredOrgIds.stream().filter(id -> !StringUtils.endsWith((CharSequence)filterParentIdsWithoutLastSperator, (CharSequence)String.valueOf(id))).collect(Collectors.toSet());
        }
        return filteredOrgIds;
    }

    public static Pair<Set<String>, Set<Long>> compressParentIdsCollectionAndFilterOrgIds(Collection<String> parentIdsCollection, Collection<Long> orgIds) {
        HashSet<Long> filteredOrgIds = orgIds == null ? Collections.emptySet() : (orgIds instanceof Set ? (HashSet<Long>)orgIds : new HashSet<Long>(orgIds));
        Stack parentIdsStack = new Stack();
        HashSet<Long> finalFilteredOrgIds = filteredOrgIds;
        parentIdsCollection.stream().filter(StringUtils::isNotBlank).sorted(String::compareTo).forEach(currentParentIds -> {
            if (parentIdsStack.isEmpty()) {
                parentIdsStack.push(currentParentIds);
            } else {
                String parentIds = (String)parentIdsStack.pop();
                OrgUtils.filterOrgIdsInParentIds(finalFilteredOrgIds, currentParentIds);
                if (!parentIds.equals(currentParentIds)) {
                    if (parentIds.startsWith((String)currentParentIds)) {
                        parentIdsStack.push(currentParentIds);
                    } else if (currentParentIds.startsWith(parentIds)) {
                        parentIdsStack.push(parentIds);
                    } else {
                        parentIdsStack.push(parentIds);
                        parentIdsStack.push(currentParentIds);
                    }
                } else {
                    parentIdsStack.push(parentIds);
                }
            }
        });
        Set parentIdsSet = parentIdsStack.stream().collect(Collectors.toSet());
        return Pair.of(parentIdsSet, filteredOrgIds);
    }

    public static void filterOrgIdsInParentIds(Set<Long> orgIds, String parentIds) {
        if (CollectionUtils.isNotEmpty(orgIds) && StringUtils.isNotBlank((CharSequence)parentIds)) {
            String filterParentIdsWithoutLastSperator = StringUtils.substring((String)parentIds, (int)0, (int)(parentIds.length() - 1));
            Set filteredOrgIds = orgIds.stream().filter(id -> !StringUtils.endsWith((CharSequence)filterParentIdsWithoutLastSperator, (CharSequence)String.valueOf(id))).collect(Collectors.toSet());
            orgIds.clear();
            orgIds.addAll(filteredOrgIds);
        }
    }
}

