package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @Author: HWT
 * @Date: 2021/8/27 14:01
 */
public class BaseDto implements IOperator {

  @ApiModelProperty(value = "创建时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  protected Date createTime;

  @ApiModelProperty(value = "创建人id")
  protected String createrId;

  @ApiModelProperty(value = "创建人名称")
  protected String createrName;

  @ApiModelProperty(value = "更新人id")
  protected String updaterId;

  @ApiModelProperty(value = "更新人名称")
  protected String updaterName;


  @ApiModelProperty(value = "更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  protected Date updateTime;


  @Override
  public Date getCreateTime() {
    return createTime;
  }

  @Override
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  @Override
  public String getCreaterId() {
    return createrId;
  }

  @Override
  public void setCreaterId(String createrId) {
    this.createrId = createrId;
  }

  @Override
  public String getCreaterName() {
    return createrName;
  }

  @Override
  public void setCreaterName(String createrName) {
    this.createrName = createrName;
  }

  @Override
  public String getUpdaterId() {
    return updaterId;
  }

  @Override
  public void setUpdaterId(String updaterId) {
    this.updaterId = updaterId;
  }

  @Override
  public String getUpdaterName() {
    return updaterName;
  }

  @Override
  public void setUpdaterName(String updaterName) {
    this.updaterName = updaterName;
  }

  @Override
  public Date getUpdateTime() {
    return updateTime;
  }

  @Override
  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }


}
