package com.xforceplus.domain.client;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.oltu.oauth2.common.message.types.GrantType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/***
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Setter
@Getter
public class ClientDto {
    /**
     * 物理主键
     */
    protected Long id;

    @JsonView(TokenView.class)
    @ApiModelProperty("clientId")
    @NotBlank(message = "clientId不能为空")
    protected String clientId;

    @ApiModelProperty("secret")
    @NotBlank(message = "secret不能为空")
    protected String secret;

    @JsonView(TokenView.class)
    @ApiModelProperty("client名称")
    @NotBlank(message = "clientName不能为空")
    protected String clientName;

    @JsonView(TokenView.class)
    @ApiModelProperty("appId")
    @NotNull(message = "appId不能为空")
    @Min(value = 1L, message = "appId需要大于0")
    protected Integer appId;

    @ApiModelProperty("scope")
    protected String scope;

    @ApiModelProperty("grantType")
    protected GrantType grantType;

    @ApiModelProperty("跳转地址")
    protected String redirectUri;

    @JsonView(TokenView.class)
    @ApiModelProperty("扩展信息")
    protected String extension;

    @ApiModelProperty("状态")
    protected Boolean status;

    @ApiModelProperty("资源码检查")
    protected Boolean resourceCheck;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08")
    protected Date createTime;

    @JsonView(TokenView.class)
    @ApiModelProperty("关联租户id")
    protected List<Long> tenantIds;
}
