package com.xforceplus.domain.company;


import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;

/***
 * @author geewit
 */
@Setter
@Getter
@ToString
public class CompanyConfigurationDto {

    @NotBlank(message = "公司税号不能为空")
    private String companyTax;

    @NotBlank(message = "传统认证不能为空")
    @Max(value = 1, message = "不合法的传统认证值，范围【1，0】")
    @Min(value = 0, message = "不合法的传统认证值，范围【1，0】")
    private String traditionAuthenFlag;

    @NotBlank(message = "查验服务不能为空")
    @Max(value = 1, message = "不合法的查验服务值，范围【1，0】")
    @Min(value = 0, message = "不合法的查验服务值，范围【1，0】")
    private String inspectionServiceFlag;

    @NotBlank(message = "极速查验通道不能为空")
    @Max(value = 1, message = "不合法的极速查验通道值，范围【1，0】")
    @Min(value = 0, message = "不合法的极速查验通道值，范围【1，0】")
    private String speedInspectionChannelFlag;
}
