package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/***
 * @author geewit
 */
@ApiModel("公司服务包")
@Setter
@Getter
public class CompanyPackage {
    protected Long id;
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;
    @ApiModelProperty(value = "租户代码")
    protected String tenantCode;
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;
    @ApiModelProperty(value = "公司id")
    protected Long companyId;
    @ApiModelProperty(value = "公司名称")
    protected String companyName;
    @ApiModelProperty(value = "服务包名称")
    protected String servicePackageName;
    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    protected Integer status;
    @ApiModelProperty(value = "税号")
    protected String taxNum;
    @ApiModelProperty(value = "创建人")
    protected String createUserName;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date createTime;
    @ApiModelProperty(value = "服务包名称集合")
    protected List<String> packageNames;

    public CompanyPackage() {
    }

    public CompanyPackage(String servicePackageName, String companyName, Integer status) {
        this.servicePackageName = servicePackageName;
        this.companyName = companyName;
        this.status = status;
    }

    public CompanyPackage(Long tenantId, String tenantName, Long companyId, String companyName, Integer status) {
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.companyId = companyId;
        this.companyName = companyName;
        this.status = status;
    }

    public CompanyPackage(Long id, Long tenantId, String tenantCode, String tenantName, Long companyId, String companyName, String taxNum, Integer status, String createUserName, Date createTime) {
        this.id = id;
        this.tenantId = tenantId;
        this.tenantCode = tenantCode;
        this.tenantName = tenantName;
        this.companyId = companyId;
        this.companyName = companyName;
        this.status = status;
        this.taxNum = taxNum;
        this.createUserName = createUserName;
        this.createTime = createTime;
    }
}
