package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/***
 * @author geewit
 */
@ApiModel("功能集")
public class ResourcesetDto implements IOperator {

    @ApiModelProperty("功能集id")
    @JsonView(View.class)
    protected Long resourcesetId;

    @ApiModelProperty("appid")
    @JsonView(View.class)
    protected Long appId;

    @ApiModelProperty("appName")
    @JsonView(View.class)
    protected String appName;

    @ApiModelProperty("资源码模块ID")
    @JsonView(View.class)
    protected Long resourceId;

    @ApiModelProperty("功能集Code")
    @JsonView(View.class)
    protected String resourcesetCode;

    @ApiModelProperty("功能集名称")
    @JsonView(View.class)
    protected String resourcesetName;

    @ApiModelProperty("功能集描述")
    @JsonView(View.class)
    protected String resourcesetDesc;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @ApiModelProperty("自定义功能集对应的角色ID")
    @JsonView(View.class)
    protected Long roleId;

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public Long getResourcesetId() {
        return resourcesetId;
    }

    public void setResourcesetId(Long resourcesetId) {
        this.resourcesetId = resourcesetId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourcesetCode() {
        return resourcesetCode;
    }

    public void setResourcesetCode(String resourcesetCode) {
        this.resourcesetCode = resourcesetCode;
    }

    public String getResourcesetName() {
        return resourcesetName;
    }

    public void setResourcesetName(String resourcesetName) {
        this.resourcesetName = resourcesetName;
    }

    public String getResourcesetDesc() {
        return resourcesetDesc;
    }

    public void setResourcesetDesc(String resourcesetDesc) {
        this.resourcesetDesc = resourcesetDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String getCreaterId() {
        return createrId;
    }

    @Override
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @Override
    public String getCreaterName() {
        return createrName;
    }

    @Override
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourcesetDto that = (ResourcesetDto) o;
        return Objects.equals(resourcesetId, that.resourcesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourcesetId);
    }
}
