/*
 * Copyright (c)  2015~2025, Xforceplus
 * All rights reserved.
 * Project: tenant-service
 * ClassName: GradingRoleDTO   
 * Date: 2021-08-31 09:51:21
 * Author: zhouxin
 */
package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.Set;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @Description: 组织角色dto
 * @CopyRight: 上海云砺信息科技有限公司
 * @Author: zhouxin
 * @Email: yf_zhouxin@xforceplus.com
 * @Date: 2021/8/31 09:51:21
 */
@Getter
@Setter
@ToString
@SuppressWarnings("all")
public class OrgRoleDTO extends RoleDto {

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("功能集集合")
    protected Set<ResourcesetDto> resourcesets = new HashSet<>();

}
