package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/***
 * @author geewit
 */
@SuppressWarnings("all")
public class TenantPolicyDto implements Serializable {
    /**
     * Password长度代码 @{value}
     */
    public final static String CREDENTIAL_LENGTH_NAME = "passwordLength";
    /**
     * Password Regex长度代码 @{value}
     */
    public final static String CREDENTIAL_REGEX_NAME = "passwordRegex";
    /**
     * Bind Auth @{value}
     */
    public final static String BIND_AUTH_NAME = "bindAuth";
    /**
     * change paasword.
     */
    public final static String CHANGE_PASSWD_NAME = "changePassword";

    /**
     * 创建公司是否需要审核, 0不需要审核，1需要
     */
    public final static String CREATE_COMPANY_AUDIT = "createCompanyAudit";

    @ApiModelProperty(value = "id")
    protected Long id;
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;
    @ApiModelProperty(value = "策略名称")
    protected String name;
    @ApiModelProperty(value = "策略值")
    protected String policy;
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;
    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPolicy() {
        return policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getUpdaterId() {
        return updaterId;
    }

    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    public String getUpdaterName() {
        return updaterName;
    }

    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TenantPolicyDto)) {
            return false;
        }
        TenantPolicyDto that = (TenantPolicyDto) o;
        return getTenantId().equals(that.getTenantId()) &&
                getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTenantId(), getName());
    }
}
