/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DateUtils {
    private static final String SPACE = " ";
    private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static final int PATTERN_CACHE_SIZE = 500;

    public static String format(Date date, String pattern) {
        return DateUtils.format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), pattern);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateUtils.createCacheFormatter(pattern);
        return localDateTime.format(formatter);
    }

    public static Date parseDate(String time, String pattern) {
        return Date.from(DateUtils.parseLocalDateTime(time, pattern).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getDateByDayEnd(Date date) {
        if (null == date) {
            return null;
        }
        return DateUtils.parseDate(DateUtils.format(date, "yyyy-MM-dd") + SPACE + "24:00:00", "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getDateByDayBegin(Date date) {
        if (null == date) {
            return null;
        }
        return DateUtils.parseDate(DateUtils.format(date, "yyyy-MM-dd") + SPACE + "00:00:00", "yyyy-MM-dd HH:mm:ss");
    }

    public static LocalDateTime parseLocalDateTime(String time, String pattern) {
        DateTimeFormatter formatter = DateUtils.createCacheFormatter(pattern);
        return LocalDateTime.parse(time, formatter);
    }

    private static DateTimeFormatter createCacheFormatter(String pattern) {
        DateTimeFormatter oldFormatter;
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter formatter = (DateTimeFormatter)FORMATTER_CACHE.get(pattern);
        if (formatter == null && FORMATTER_CACHE.size() < 500 && (oldFormatter = FORMATTER_CACHE.putIfAbsent(pattern, formatter = DateTimeFormatter.ofPattern(pattern))) != null) {
            formatter = oldFormatter;
        }
        return formatter;
    }

    public static long getCustomTime(int hour, int minute, int second) {
        Calendar time = Calendar.getInstance();
        time.set(11, hour);
        time.set(12, minute);
        time.set(13, second);
        time.set(14, 0);
        return time.getTimeInMillis();
    }

    public static boolean before(Date aDate, Date bDate, boolean includeSameDate) {
        Calendar aCal = org.apache.commons.lang3.time.DateUtils.toCalendar((Date)aDate);
        Calendar bCal = org.apache.commons.lang3.time.DateUtils.toCalendar((Date)bDate);
        return DateUtils.before(aCal, bCal, includeSameDate);
    }

    public static boolean after(Date aDate, Date bDate, boolean includeSameDate) {
        Calendar aCal = org.apache.commons.lang3.time.DateUtils.toCalendar((Date)aDate);
        Calendar bCal = org.apache.commons.lang3.time.DateUtils.toCalendar((Date)bDate);
        return DateUtils.after(aCal, bCal, includeSameDate);
    }

    public static boolean before(Calendar aCal, Calendar bCal, boolean includeSameDate) {
        int compared = DateUtils.calendarCompareTo(aCal, bCal);
        if (compared > 0) {
            return false;
        }
        if (compared == 0) {
            return includeSameDate;
        }
        return true;
    }

    public static boolean after(Calendar aCal, Calendar bCal, boolean includeSameDate) {
        int compared = DateUtils.calendarCompareTo(aCal, bCal);
        if (compared > 0) {
            return true;
        }
        if (compared == 0) {
            return includeSameDate;
        }
        return false;
    }

    public static boolean beforeNow(Date date, boolean includeSameDate) {
        Calendar nowCal = Calendar.getInstance();
        Calendar cal = org.apache.commons.lang3.time.DateUtils.toCalendar((Date)date);
        return DateUtils.before(cal, nowCal, includeSameDate);
    }

    public static boolean afterNow(Date date, boolean includeSameDate) {
        Calendar nowCal = Calendar.getInstance();
        Calendar cal = org.apache.commons.lang3.time.DateUtils.toCalendar((Date)date);
        return DateUtils.after(cal, nowCal, includeSameDate);
    }

    public static int calendarCompareTo(Calendar aCal, Calendar bCal) {
        aCal.set(11, 0);
        aCal.set(12, 0);
        aCal.set(13, 0);
        aCal.set(14, 0);
        bCal.set(11, 0);
        bCal.set(12, 0);
        bCal.set(13, 0);
        bCal.set(14, 0);
        return aCal.compareTo(bCal);
    }
}

