/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public interface BaseEnum<T> {
    public T getValue();

    public static <E extends Enum<E>, T> boolean isValid(Class<E> clazz, T value) {
        return BaseEnum.getEnum(clazz, value) != null;
    }

    public static <E extends Enum<E>, T> E getEnum(@NonNull Class<E> clazz, T value) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return (E)(value == null ? null : (Enum)EnumUtils.getEnumList(clazz).stream().filter(c -> value.equals(((BaseEnum)((Object)c)).getValue())).findFirst().orElse(null));
    }

    public static <E extends Enum<E>, T> E getEnum(@NonNull Class<E> clazz, Collection<T> value, E defaultEnum) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (value == null || CollectionUtils.isEmpty(value)) {
            return defaultEnum;
        }
        return (E)EnumUtils.getEnumList(clazz).stream().filter(c -> value.contains(((BaseEnum)((Object)c)).getValue())).findFirst().orElse(defaultEnum);
    }

    public static <E extends Enum<E>, T> String enumToString(Class<E> e) throws JsonProcessingException {
        List d1 = EnumUtils.getEnumList(e);
        return Jackson2ObjectMapperBuilder.json().build().writeValueAsString((Object)d1);
    }
}

