package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author HWT
 * @since 2021/8/27 14:01
 */
@Setter
@Getter
public class BaseDto implements IOperator {

  @ApiModelProperty(value = "创建时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  protected Date createTime;

  @ApiModelProperty(value = "创建人id")
  protected String createrId;

  @ApiModelProperty(value = "创建人名称")
  protected String createrName;

  @ApiModelProperty(value = "更新人id")
  protected String updaterId;

  @ApiModelProperty(value = "更新人名称")
  protected String updaterName;


  @ApiModelProperty(value = "更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  protected Date updateTime;


}
