package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Collection;
import java.util.Objects;

/**
 * @author geewit
 */
@ApiModel(value = "reactjs tree")
@Setter
@Getter
@ToString
public class TreeNode {


    /**
     * 产品服务包，功能集、资源码
     */
    @ApiModelProperty("type")
    @JsonIgnore
    private String type;
    @ApiModelProperty("key")
    private Long key;
    @JsonIgnore
    @ApiModelProperty("id")
    private String id;
    @ApiModelProperty("title")
    private String title;
    @ApiModelProperty("pid")
    @JsonIgnore
    private Long pid;
    @ApiModelProperty("parentKey")
    @JsonIgnore
    private String parentKey;
    @ApiModelProperty("children")
    private Collection<TreeNode> children;
    /**
     * 资源路径
     */
    @ApiModelProperty("path")
    @JsonIgnore
    private String path;


    @ApiModelProperty("是否有权限")
    private boolean hasPermission;

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()){
            return false;
        }
        TreeNode that = (TreeNode) obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key);
    }
}
