package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author geewit
 */
@ApiModel(value = "帐号平台关联表")
@Setter
@Getter
public class AccountPlatformRelDto implements Serializable {
    @ApiModelProperty(value = "id")
    protected Long id;

    @ApiModelProperty(value = "帐号id")
    protected Long accountId;

    @ApiModelProperty(value = "平台类型 1 微信")
    protected Integer platformType;

    @ApiModelProperty(value = "平台id")
    protected String platformId;

    @ApiModelProperty(value = "平台应用Id")
    protected String platformAppId;

    @ApiModelProperty(value = "状态", notes = "1：启用 0：禁用")
    protected Integer status;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "生效时间")
    protected Date enableTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "创建时间")
    protected Date createTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "更新时间")
    protected Date updateTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "用户ID")
    protected String userId;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "应用类型")
    protected String appType;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "扩展字段1")
    protected String ext1;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "扩展字段2")
    protected String ext2;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "扩展字段3")
    protected String ext3;

}
