package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author geewit
 */
@ApiModel(value = "微信信息表")
@Setter
@Getter
public class WechatInfoDto {
    @ApiModelProperty(value = "id")
    protected Long id;

    @ApiModelProperty(value = "access_token")
    protected String accessToken;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "token生成时间")
    protected Date tokenTime;

    @ApiModelProperty(value = "token有效期")
    protected Integer tokenPeriod;

    @ApiModelProperty(value = "jsapi_ticket")
    protected String jsapiTicket;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "ticket生成时间")
    protected Date ticketTime;

    @ApiModelProperty(value = "ticket有效期")
    protected Integer ticketPeriod;

    @ApiModelProperty(value = "状态", notes = "1：启用 0：禁用")
    protected Integer status;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    @ApiModelProperty(value = "创建时间")
    protected Date createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    @ApiModelProperty(value = "更新时间")
    protected Date updateTime;

}
