/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyConfigDTO.java   2020-09-21 13-48-12
 * Author: Evan
 */
package com.xforceplus.domain.company;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Title: 公司服务导出DTO
 * </p>
 * <p>
 * Description: 公司服务导出DTO
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-21 13-48-12
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class CompanyConfigDTO {

    /**
     * 公司名称
     */
    protected String companyName;
    /**
     * 公司税号
     */
    private String taxNum;
    /**
     * 传统认证：范围【1，0】
     */
    private Integer traditionAuthenFlag;

    /**
     * 查验服务状态：范围【1，0】
     */
    private Integer inspectionServiceFlag;

    /**
     * 极速查验通道：：范围【1，0】
     */
    private Integer speedInspectionChannelFlag;
}
