package com.xforceplus.domain.conf;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.BaseDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.stream.IntStream;

/**
 * @Author: HWT
 * @Date: 2022/1/06 15:35
 */
@ApiModel(value = "隐私协议版本记录")
@Setter
@Getter
public class PrivacyAgreementDto<P extends PrivacyAgreementProtocolDto> extends BaseDto {

    @ApiModelProperty(value = "id")
    protected Long id;

    @JsonView(View.class)
    @ApiModelProperty(value = "整体描述内容")
    protected String content;

    @JsonView(View.class)
    @ApiModelProperty(value = "状态", notes = "1：启用 0：未启用")
    protected Integer status;


    @JsonView(View.class)
    @ApiModelProperty(value = "公司类型", notes = "默认 1:云励")
    protected Integer companyType;


    @JsonView(View.class)
    @ApiModelProperty(value = "隐私版本号")
    protected String version;

    @JsonView(View.class)
    @JsonManagedReference
    @ApiModelProperty(value = "隐私明细")
    protected List<P> protocols;

    public static <P extends PrivacyAgreementProtocolDto> void sortProtocols(List<P> protocols) {
        if (protocols != null && !protocols.isEmpty()) {
            protocols.sort((o1, o2) -> {
                if (o1.getOrdinal() == null) {
                    o1.setOrdinal(Integer.MAX_VALUE);
                }
                if (o2.getOrdinal() == null) {
                    o2.setOrdinal(Integer.MAX_VALUE);
                }
                return o1.getOrdinal().compareTo(o2.getOrdinal());
            });
        }
    }

    public static <P extends PrivacyAgreementProtocolDto> void arrangeProtocolsOrdinal(List<P> protocols) {
        if (protocols == null || protocols.isEmpty()) {
            return;
        }
        IntStream.range(0, protocols.size()).forEach(i -> protocols.get(i).setOrdinal(i + 1));
    }
}
