package com.xforceplus.domain.constants;

/**
 * @author zombie
 */
public class ErrorMessage {

    public static final String TENANT_POLICY_EXIST = "租户策略{0}已经存在";
    public static final String INVALID_TENANT_POLICY = "无效的租户策略{0}";

    public static final String ILLEGAL_USER_CONTEXT = "没有合法用户上下文";

    public static final String INVALID_TENANT_ID = "租户ID{0}不存在";

    public static final String INVALID_POLICY_ID = "租户策略ID{0}不存在";
    public static final String FORBIDDEN_CHANGE_POLICY_NAME = "策略名不可修改";

    public static final String INVALID_LOGIN_NAME = "无效的登录名{0}";

    public static final String LOGIN_NAME_NOT_EXIST = "不存在的登录名";

    public static final String ACCOUNT_NOT_EXIST = "账号{0}不存在";

    public static final String INVALID_INPUT = "无效的入参数据";

    /**
     * sample:用户名/密码错误，账户已锁定，请于2022-07-18 14:45:11后再试
     */
    public static final String ACCOUNT_LOCK = "用户名/密码错误，账户已锁定，请于{0,date,yyyy-MM-dd HH:mm:ss}后再试";

    /**
     * sample:用户名/密码错误, 还有3次机会
     */
    public static final String LOGIN_FAILED_TIMES = "用户名/密码错误, 还有{0}次机会";

    public static final String PASSWORD_ERROR = "用户名/密码错误";

    public static final String USER_NAME_CANNOT_BE_NULL = "登录用户名不能为空";

    public static final String TENANT_NOT_FOUND = "未找到租户实体({0})";

    public static final String TENANT_AND_USER_NOT_FOUND = "未找到用户实体(tenantCode: {0}, username:{1})";

    public static final String ACCOUNT_NOT_FOUND = "不存在id({0})的Account";

    public static final String ACCOUNT_EXPIRED = "用户已过期";

    public static final String SEND_CAPTCHA = "请先发送验证码。";
    public static final String INPUT_CORRECT_PHONE_NUMBER = "请输入正确的手机号码！";

    public static final String CHECK_FAILED = "验证失败，请检查输入信息！";

    public static final String CAPTCHA_CHECK_FAILED = "验证码验证失败。";

    public static final String CAPTCHA_CHECK_EXCEPTION = "验证码验证异常。";

    public static final String UPDATE_PASSWORD = "请修改密码";

    public static final String PASSWORD_CANNOT_BE_NULL = "密码不能为空";

    public static final String QUERY_USER_ERROR = "获取用户失败";

    public static final String ACCOUNT_DISABLED = "账号未启用";
    public static final String USER_DISABLED = "用户未启用";

    public static final String BIND_EMAIL_OR_PHONE = "绑定手机或者邮箱";

    public static final String CHECK_MOBILE = "请先进行手机号登录验证！";

    public static final String INVALID_EMAIL_OR_MOBILE = "手机或者邮箱有误，无法登录。";

    public static final String NO_TWO_FACTOR_STRATEGY_AVAILABLE = "租户策略无需双因子认证";

    public static final String ACCOUNT_LOGIN_FIRST = "请先进行用户名密码登录！";

    public static final String CAPTCHA_CANNOT_BE_NULL = "验证码不能为空!";

    public static final String ILLEGAL_ACCOUNT = "账号必须为手机或者邮箱！";

    public static final String DOUBLE_AUTH = "二次认证手机号/或邮箱";

    public static final String DOUBLE_AUTH_PASSWORD = "二次认证密码";

    public static final String PASSWORD_MIN_LENGTH = "密码不能短于6个字符";
    public static final String PASSWORD_MAX_LENGTH = "密码不能超过32个字符";
    public static final String PASSWORD_MIN_LENGTH_GREATER_THAN_MAX_LENGTH = "密码最小长度不能大于密码最大长度";
    public static final String PASSWORD_EXPIRED_DAYS_SHOULD_BE_GREATER_THAN_ZERO = "密码有效期必须是大于等于0的整数，最大9999";
    public static final String PASSWORD_REMIND_DAYS_SHOULD_LESS_THAN_EXPIRED_DAYS = "密码失效前提醒时间必须小于等于密码过期时间";
    public static final String PASSWORD_REMIND_DAYS_SHOULD_BE_GREATER_THAN_ZERO = "密码失效前提醒时间必须大于等于0的整数，最大9999";

    public static final String INVALID_TWO_FACTOR_PREFER_TYPE = "无效的二次认证类型";

    public static final String INVALID_COOKIE_EXPIRED_HOURS = "无效的cookie失效时间";
    public static final String INVALID_DOMAIN = "无效的域名";
    public static final String INVALID_CAPTCHA_THRESH_HOLD = "密码错误次数只能是1~20的整数";

    public static final String INVALID_PASSWORD_ERROR_COUNT = "密码错误次数只能是1~20的整数";
    public static final String INVALID_LOCK_TIME = "冻结时间只能是1~1440的整数";
    public static final String INVALID_REPETITION_TIMES = "密码重复使用次数设置只能在1~20";

    public static final String TENANT_CODE_EXIST = "租户编码({0})已存在";
    public static final String TENANT_NAME_EXIST = "租户名称({0})已存在";
    public static final String COMPANY_TAX_NUMBER_CANNOT_BE_NULL = "公司税号不能为空";
    public static final String COMPANY_NAME_CANNOT_BE_NULL = "公司名称不能为空";

    public static final String CURRENT_USER_IS_NOT_ORG_ADMIN = "当前用户不是组织管理员";

    public static final String ORG_NOT_EXIST = "组织({0})不存在";

    public static final String USER_NOT_FOUND = "用户不存在";

    public static final String CURRENT_ORG_ALLOW_ONE_ADMIN_ONLY = "当前组织仅允许设置一个管理员";

    public static final String INPUT_USERS_ARE_NOT_ORG_ADMIN = "传入的用户不是组织管理员";
    public static final String USER_IS_NOT_ORG_ADMIN = "用户{0}不是组织管理员";

    public static final String CANNOT_CANCEL_CURRENT_USER_ADMIN = "不能取消自己在当前组织的管理员";
    public static final String CANNOT_ADD_DEFAULT_ORG_USER_BIND = "默认组织角色无法手工添加授权";
    public static final String CANNOT_CANCEL_DEFAULT_ORG_USER_BIND = "默认组织角色无法手工解除授权";
    public static final String ORG_ROLE_NOT_EXIST = "组织角色({0})不存在";

    public static final String COMPANY_INFO_REQUIRED = "类型为公司的组织需要输入公司信息";

    public static final String ORG_VIRTUAL_NODE_ID_NOT_EXIST = "虚拟组织节点{0}不存在";

    public static final String ROLE_NOT_EXIT = "未找到角色实体{0}";

    public static final String NO_PERMISSION = "当前用户不是管理员，禁止操作";

    public static final String LAST_ORG_ADMIN_CANNOT_BE_CANCEL = "唯一的租户管理员不能被取消";

    public static final String SERVICE_PACKAGE_CANNOT_BE_NULL = "产品服务包ID或者产品服务包code不能同时为空";

}
