package com.xforceplus.domain.device;

import io.geewit.core.utils.enums.Name;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author feihu.wang
 */
@SuppressWarnings("all")
public enum InvoiceType implements Name {
    /**
     * 增值税普通发票
     */
    NORMAL("c"),
    /**
     * 增值税专用发票
     */
    SPECIAL("s"),
    /**
     * 机动车销售发票
     */
    VEHICLE("v"),
    /**
     * 通用机打发票
     */
    UNIVERSAL("t"),
    /**
     * 增值税电子普通发票
     */
    ELECTRONIC("ce"),
    /**
     * 卷票
     */
    NORMAL_ROLL("ju"),

    NORMAL_SPECIAL("cs"),

    /**
     * 增值税电子专用发票
     */
    SPECIAL_ELECTRONIC("se");

    private final String name;

    InvoiceType(String name) {
        this.name = name;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceType.values()).filter(t -> t.name().equals(value)).findFirst()
                .orElseThrow(() -> new IllegalArgumentException("不存在对应类型的票"));
    }

    public static List<String> special() {
        return Arrays.asList(SPECIAL.name(), SPECIAL_ELECTRONIC.name());
    }

    public static List<String> toList() {
        List<String> invoiceTypes = Stream.of(InvoiceType.values()).map(e -> e.name()).collect(Collectors.toList());
        return invoiceTypes;
    }

    public boolean isNormal() {
        return this.equals(NORMAL) || this.equals(ELECTRONIC) || this.equals(NORMAL_ROLL);
    }

    public boolean isSpecial() {
        return this.equals(SPECIAL) || this.equals(SPECIAL_ELECTRONIC);
    }
}
