package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.ExtensionDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * @author geewit
 */
@ApiModel(value = "组织扩展")
@Setter
@Getter
public class OrgExtensionDto extends ExtensionDto {

    @ApiModelProperty("组织id")
    @JsonView(View.class)
    protected Long orgStructId;

    @JsonView(View.List.class)
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @JsonView(View.List.class)
    @ApiModelProperty(value = "租户code")
    protected String tenantCode;

    @JsonView({View.List.class})
    @ApiModelProperty("组织名称")
    protected String orgName;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OrgExtensionDto) {
            OrgExtensionDto that = (OrgExtensionDto) o;
            return Objects.equals(this.orgStructId, that.getOrgStructId()) && Objects.equals(super.extensionKey, that.extensionKey);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.orgStructId, super.extensionKey);
    }
}
