package com.xforceplus.domain.orgVirtual;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@ToString
@Setter
@Getter
public class OrgVirtualDTO implements IOperator {

    /**
     * 虚拟组织id
     */
    @ApiModelProperty(value = "虚拟组织id")
    protected Long orgVirtualId;


    /**
     * 虚拟组织id
     */
    @ApiModelProperty(value = "实体组织id")
    protected Long orgStructId;


    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;

    /**
     * 组织代码
     */
    @ApiModelProperty(value = "组织代码")
    protected String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    protected String orgName;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称")
    protected String shortName;

    /**
     * 组织备注
     */
    @ApiModelProperty(value = "组织备注")
    protected String orgDesc;

    /**
     * 状态：0 停用 1 启用
     */
    @ApiModelProperty(value = "状态：0 停用 1 启用")
    protected Integer status;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 组织树id
     */
    @ApiModelProperty(value = "组织树id")
    protected Long orgVirtualNodeId;
}
