package com.xforceplus.domain.orgVirtual;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
* @copyright © 上海云砺信息科技有限公司
* @author zhouxin
* @date 2021/8/4 10:51
*/
@Setter
@Getter
public class OrgVirtualOrgStructDTO implements IOperator {

    @ApiModelProperty(value = "主键")
    protected Long id;

    /**
     * 虚拟组织id
     */
    @ApiModelProperty(value = "虚拟组织id")
    protected Long orgVirtualId;


    /**
     * 虚拟组织id
     */
    @ApiModelProperty(value = "实体组织id")
    protected Long orgStructId;


    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;


    /**
     * 组织名称
     */
    @ApiModelProperty(value = "行政组织名称")
    protected String orgStructName;


    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 组织树id
     */
    @ApiModelProperty(value = "组织树id")
    protected Long orgVirtualNodeId;

    @Override
    public String toString() {
        return "OrgVirtualOrgStructDTO{" +
            "id=" + id +
            ", orgVirtualId=" + orgVirtualId +
            ", orgStructId=" + orgStructId +
            ", tenantId=" + tenantId +
            ", orgStructName='" + orgStructName + '\'' +
            ", createTime=" + createTime +
            ", createrId='" + createrId + '\'' +
            ", createrName='" + createrName + '\'' +
            ", updaterId='" + updaterId + '\'' +
            ", updaterName='" + updaterName + '\'' +
            ", updateTime=" + updateTime +
            ", orgVirtualNodeId=" + orgVirtualNodeId +
            '}';
    }
}
