package com.xforceplus.domain.response.code;

/**
 * @author libaozhong
 * 命名规则
 * UC===ucenter用户中心
 * TS===tenant-service
 * CM===公共返回code
 * 后四位自定义  0000默认失败 1111默认成功
 */
@SuppressWarnings("all")
public interface Rep {

    interface CommonCode {
        //失败
        String FAIL = "UCTSCM0000";
        //资源已经存在
        String EXIST_RESOURCE = "UCTSCM0001";
        //参数缺失
        String PARAM_ABSENT = "UCTSCM0002";
        //参数格式校验不正确
        String PARAM_FORMAT_WRONG = "UCTSCM0003";
        //参数格式校验不正确
        String PARAM_LOGIC_WRONG = "UCTSCM0004";
        //未知异常
        String PARAM_UNKOWN = "UCTSCM0005";
        //数据超过限制
        String EXCEED_LIMIT = "UCTSCM0006";
        //参数缺失
        String NOT_EXIST = "UCTSCM0007";

        /**
         * 非法数据
         */
        String INVALID_DATA = "UCTSCM008";
        //成功
        String OK = "1";
    }

    interface TenantCode {
        //租户创建不存在角色
        String NO_EXIST_ROLE = "UCTSTC0001";
    }

    interface AccountCode {
        int FAIL = 0;
        int INVALID_USERNAME_OR_PASSWORD = 3;
        int NEED_CAPTCHA = 5;
        int CHANGE_PASSWORD = 6;
        int BIND_AUTH = 7;
        int DOUBLE_AUTH_EMAIL_PHONE = 8;
        int DOUBLE_AUTH_PWD = 9;
        int DUPLICATED_PASSWORD_IN_HISTORY = 10;
    }

    interface OrgErrorCode{
        String ORG_CODE_EXIST="USEROG0001";
    }
}
