/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: StringInclude.java   2020-09-25 14-10-24
 * Author: Evan
 */
package com.xforceplus.validation.constraints;

import com.xforceplus.validation.validator.StringIncludeValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <p>
 * Title: 字符串包含判断
 * </p>
 * <p>
 * Description:  字符串包含判断 required=true时，为null时 ,required=false,当字段为空时，则不校验并返回true
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-25 14-10-24
 * @since V1.0
 */
@Documented
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = StringIncludeValidator.class)
@Repeatable(StringInclude.List.class)
public @interface StringInclude {
    /**
     * @return
     */
    String message() default "{该值不在范围之内}";

    /**
     *groups
     */
    Class<?>[] groups() default {};

    /**
     * payload
     *
     * @return
     */
    Class<? extends Payload>[] payload() default {};

    /**
     * 校验值
     * @return
     */
    String[] range() default {};

    /**
     * 是否必要验证，默认为必要的
     */
    boolean required() default true;

    /**
     * Defines several {@code @Range} annotations on the same element.
     */

    @Documented
    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE})
    @Retention(RUNTIME)
    @interface List {
        StringInclude[] value();
    }
}
