/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.domain.device;

import io.geewit.core.utils.enums.Name;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InvoiceType implements Name
{
    NORMAL("c"),
    SPECIAL("s"),
    VEHICLE("v"),
    UNIVERSAL("t"),
    ELECTRONIC("ce"),
    NORMAL_ROLL("ju"),
    NORMAL_SPECIAL("cs"),
    SPECIAL_ELECTRONIC("se");

    private final String name;

    private InvoiceType(String name) {
        this.name = name;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceType.values()).filter(t -> t.name().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
    }

    public static List<String> special() {
        return Arrays.asList(SPECIAL.name(), SPECIAL_ELECTRONIC.name());
    }

    public static List<String> toList() {
        List<String> invoiceTypes = Stream.of(InvoiceType.values()).map(e -> e.name()).collect(Collectors.toList());
        return invoiceTypes;
    }

    public boolean isNormal() {
        return this.equals((Object)NORMAL) || this.equals((Object)ELECTRONIC) || this.equals((Object)NORMAL_ROLL);
    }

    public boolean isSpecial() {
        return this.equals((Object)SPECIAL) || this.equals((Object)SPECIAL_ELECTRONIC);
    }
}

