package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * @author geewit
 */
@ApiModel(value = "组织扩展")
@Setter
@Getter
@ToString
public class ExtensionDto {

    @ApiModelProperty("扩展字段key")
    @JsonView(View.class)
    protected String extensionKey;

    @ApiModelProperty("扩展字段value")
    @JsonView(View.class)
    protected String extensionValue;

    @ApiModelProperty(value = "状态", example = "1", notes = "1:启用, 2:作废")
    @JsonView(View.class)
    protected Integer status;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

}
