package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@ApiModel(value = "帐号")
@Setter
@Getter
public class AccountDto implements IOperator {

    @JsonView(View.class)
    @ApiModelProperty(value = "帐号id")
    protected Long accountId;

    @JsonView(View.class)
    @ApiModelProperty(value = "登录email")
    protected String email;

    @ApiModelProperty(value = "帐号密码")
    @JsonIgnore
    protected String password;

    @JsonView(View.class)
    @ApiModelProperty(value = "登录手机")
    protected String telPhone;

    @JsonView(View.class)
    @ApiModelProperty(value = "状态", notes = "1：启用 0：禁用")
    protected Integer status;

    @JsonView(View.class)
    @ApiModelProperty(value = "username")
    protected String username;

    protected String salt;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonView(View.class)
    @ApiModelProperty(value = "是否需要改密码")
    protected Boolean changePasswordFlag;

    @ApiModelProperty(value = "密码更新时间")
    protected Date pwdLastUpdateTime;

    @ApiModelProperty(value = "二次验证标识")
    @JsonView(View.class)
    protected Boolean doubleAuthFlag;

    @JsonView(View.class)
    @ApiModelProperty(value = "是否需要绑定手机或者邮箱")
    protected Boolean bindAuthFlag;

    @JsonView(View.class)
    @ApiModelProperty(value = "密码长度")
    protected Integer passwdLength;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountDto that = (AccountDto) o;
        return Objects.equals(this.accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.accountId);
    }
}
