package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2020/12/3 20:48
 * 功能描述:
 * 修改历史:
 */
@Getter
@Setter
public class LoginLogDto {

    @ApiModelProperty("id")
    protected Long id;

    @ApiModelProperty("租户Id")
    protected Long tenantId;

    @ApiModelProperty("账号Id")
    protected Long accountId;

    @ApiModelProperty("用户id")
    protected Long userId;

    @ApiModelProperty("登录账号")
    protected String loginName;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    protected Date loginTime;

}
