package com.xforceplus.domain.conf;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.BaseDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author HWT
 * @since  2022/1/06 15:35
 */
@ApiModel(value = "系统枚举值记录表")
@Setter
@Getter
public class SysEnumDto extends BaseDto {

  @ApiModelProperty(value = "id")
  protected Long id;

  @JsonView(View.class)
  @ApiModelProperty(value = "枚举值组的名称")
  protected String enumGroupName;

  @JsonView(View.class)
  @ApiModelProperty(value = "枚举值的名称")
  protected String enumName;


  @JsonView(View.class)
  @ApiModelProperty(value = "枚举值的value")
  protected String enumValue;

  @JsonView(View.class)
  @ApiModelProperty(value = "枚举值value的类型")
  protected String enumType;

  @JsonView(View.class)
  @ApiModelProperty(value = "枚举值的顺序")
  protected Integer enumSeq;
}
