package com.xforceplus.domain.greyscale;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author zombie
 */
@Getter
@Setter
@ToString
public class GreyscaleConfigDto implements IOperator {
    protected Long id;
    @ApiModelProperty(value = "配置标识ID")
    protected Long identifierId;
    @ApiModelProperty(value = "配置标识Code")
    protected String identifierCode;
    @ApiModelProperty(value = "是否启用")
    protected Boolean enabled;
    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "配置标识类型，1租户，2税号，3公司")
    protected Integer identifierType;
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;
}
