package com.xforceplus.domain.log;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.enums.ActionCodeEnum;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2020/12/3 20:48
 * 功能描述:
 * 修改历史:
 */
@ToString
@Setter
@Getter
public class SystemLogDTO {

    @ApiModelProperty("id")
    protected Long id;

    @ApiModelProperty("表名")
    protected String tableName;

    @ApiModelProperty("批次id")
    protected String batchId;

    @ApiModelProperty("租户ID")
    protected Long tenantId;

    @ApiModelProperty("操作主键ID")
    protected Long identityId;

    @ApiModelProperty("'操作业务类型：'")
    protected String businessType;

    @ApiModelProperty("' 操作类型:I U D")
    protected ActionCodeEnum actionCode;

    @ApiModelProperty("操作内容：json格式相关数据")
    protected String content;

    @ApiModelProperty("创建人ID")
    protected String createUserId;

    @ApiModelProperty("创建人姓名")
    protected String createUserName;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    @ApiModelProperty(value = "创建时间")
    protected Date createTime;

    @ApiModelProperty("请求ID")
    protected String loginId;

    @ApiModelProperty("备注")
    protected String remark;

    public SystemLogDTO batchId(String batchId) {
        this.batchId = batchId;
        return this;
    }

    public SystemLogDTO remark(String remark) {
        this.remark = remark;
        return this;
    }

    public SystemLogDTO businessType(String businessType) {
        this.businessType = businessType;
        return this;
    }
}
