package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author duanhy
 */
@ApiModel(value = "组织类型")
@Setter
@Getter
public class OrgTypeDto implements IOperator {

    @JsonView(View.class)
    @ApiModelProperty(value = "组织类型ID")
    protected Integer orgTypeId;

    @JsonView(View.class)
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;

    @JsonView(View.class)
    @ApiModelProperty(value = "类型名称")
    @JsonIgnore
    protected String name;

    @JsonView(View.class)
    @ApiModelProperty(value = "类型code")
    protected String code;

    @JsonView(View.class)
    @ApiModelProperty(value = "状态", notes = "1：启用 0：停用")
    protected Integer status;

    @JsonView(View.class)
    @ApiModelProperty(value = "删除状态", notes = "true：删除 false：未删除")
    protected Boolean deleted;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

}
