package com.xforceplus.domain.orgVirtual;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author duanhaiyuan
 */
@ToString
@Setter
@Getter
public class OrgVirtualNodeDTO implements IOperator {

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    protected Long orgVirtualNodeId;

    /**
     * 虚拟组织ID
     */
    @ApiModelProperty(value = "虚拟组织ID")
    protected Long orgVirtualId;

    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;

    /**
     * 上级组织id
     */
    @ApiModelProperty(value = "上级组织id")
    protected Long parentId;

    /**
     * 上级组织路径
     */
    @ApiModelProperty(value = "上级组织路径")
    protected String parentIds;

    /**
     * 组织类型id
     */
    @ApiModelProperty(value = "组织类型id")
    protected Long nodeTypeId;

    /**
     * 下级组织数量
     */
    @ApiModelProperty(value = "下级组织数量")
    protected Integer childrenCount;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;
}
