package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@ApiModel("功能集")
@Setter
@Getter
public class ResourcesetDto implements IOperator {

    @ApiModelProperty("功能集id")
    @JsonView(View.class)
    protected Long resourcesetId;

    @ApiModelProperty("appid")
    @JsonView(View.class)
    protected Long appId;

    @ApiModelProperty("appName")
    @JsonView(View.class)
    protected String appName;

    @ApiModelProperty("资源码模块ID")
    @JsonView(View.class)
    protected Long resourceId;

    @ApiModelProperty("功能集Code")
    @JsonView(View.class)
    protected String resourcesetCode;

    @ApiModelProperty("功能集名称")
    @JsonView(View.class)
    protected String resourcesetName;

    @ApiModelProperty("功能集描述")
    @JsonView(View.class)
    protected String resourcesetDesc;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @ApiModelProperty("自定义功能集对应的角色ID")
    @JsonView(View.class)
    protected Long roleId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourcesetDto that = (ResourcesetDto) o;
        return Objects.equals(resourcesetId, that.resourcesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourcesetId);
    }
}
