package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.tenant.view.SysRole;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.Tag;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import java.util.*;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 权限角色
 *
 * @author geewit
 */
@SuppressWarnings("all")
@Setter
@Getter
public class RoleDto extends TokenRole implements IOperator {

    @ApiModelProperty(value = "角色描述")
    @JsonView(View.class)
    protected String roleDesc;

    @ApiModelProperty(value = "创建人id")
    @JsonView(View.class)
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    @JsonView(View.class)
    protected String createrName;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "更新人id")
    @JsonView(View.class)
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    @JsonView(View.class)
    protected String updaterName;

    @ApiModelProperty(value = "更新时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("角色标签集合")
    protected Set<Tag> tags;

    @JsonView(SysRole.class)
    @ApiModelProperty("租户集合")
    protected Set<Long> tenantIds;

    @JsonView(SysRole.class)
    @ApiModelProperty("功能集id集合")
    protected Set<Long> resourcesetIds;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("功能集集合")
    protected Set<ResourcesetDto> resourcesets;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("自定义功能集下资源码集合")
    protected Set<ResourceDto> resources;

    @ApiModelProperty("角色关联的员工数量")
    @JsonView(View.class)
    protected Long userCnt = 0L;

    @ApiModelProperty("默认角色/默认绑定人员")
    @JsonView(View.class)
    protected Boolean defaultBindUser;

    public void setRoleName(String roleName) {
        this.name = roleName;
    }

    public void setRoleCode(String roleCode) {
        this.code = roleCode;
    }

    @JsonView(View.class)
    public boolean isValid() {
        return this.status != null && this.status != 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleDto that = (RoleDto) o;
        if (this.id == null || this.id == 0) {
            return false;
        }
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String toString() {
        return "Role{" +
                "id=" + id +
                ", tenantId=" + tenantId +
                ", code=" + code +
                ", name=" + name +
                ", tags=" + tags +
                '}';
    }
}
