package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.apache.commons.lang3.StringUtils;

/**
 * @author duanhy
 */
@SuppressWarnings("all")
@ApiModel(value = "租户管理员")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
public class TenantManager {

    @JsonView({View.class})
    @ApiModelProperty(value = "租户id")
    private Long tenantId;

    @JsonView({View.class})
    @ApiModelProperty(value = "域账号")
    private String account;

    @JsonView({View.class})
    @ApiModelProperty(value = "邮箱账号")
    private String emailAccount;

    @JsonView({View.class})
    @ApiModelProperty(value = "手机账号")
    private String phoneAccount;

    @JsonView({View.class})
    @ApiModelProperty(value = "姓名")
    private String name;

    @JsonView({View.class})
    @ApiModelProperty(value = "userId")
    private Long userId;

    @JsonView({View.class})
    @ApiModelProperty(value = "accountId")
    private Long accountId;

    @JsonIgnore
    public String getIdentifier() {
        if (StringUtils.isNotBlank(this.name)) {
            return this.name;
        }
        if (StringUtils.isNotBlank(account)) {
            return this.account;
        }
        if (StringUtils.isNotBlank(emailAccount)) {
            return this.emailAccount;
        }
        if (StringUtils.isNotBlank(phoneAccount)) {
            return this.phoneAccount;
        }
        return null;
    }
}