package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@SuppressWarnings("all")
@Setter
@Getter
public class TenantPolicyDto implements IOperator {
    /**
     * Password长度代码 @{value}
     */
    public final static String CREDENTIAL_LENGTH_NAME = "passwordLength";
    /**
     * Password Regex长度代码 @{value}
     */
    public final static String CREDENTIAL_REGEX_NAME = "passwordRegex";
    /**
     * Bind Auth @{value}
     */
    public final static String BIND_AUTH_NAME = "bindAuth";
    /**
     * change paasword.
     */
    public final static String CHANGE_PASSWD_NAME = "changePassword";

    /**
     * 创建公司是否需要审核, 0不需要审核，1需要
     */
    public final static String CREATE_COMPANY_AUDIT = "createCompanyAudit";

    /**
     * 加载用户资源码使用新逻辑, 0: 不使用新逻辑,  1: 使用新逻辑
     */
    public final static String LOAD_USER_RESOURCE_NEW = "loadUserResourceNew";

    @ApiModelProperty(value = "id")
    protected Long id;
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;
    @ApiModelProperty(value = "策略名称")
    protected String name;
    @ApiModelProperty(value = "策略值")
    protected String policy;
    @ApiModelProperty(value = "创建人id")
    protected String createrId;
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;
    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;
    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @ApiModelProperty(value = "租户代码")
    protected String tenantCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TenantPolicyDto)) {
            return false;
        }
        TenantPolicyDto that = (TenantPolicyDto) o;
        return Objects.equals(this.tenantId, that.tenantId) &&
                Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tenantId, this.name);
    }
}
