package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author cpp
 */
@ApiModel("租户服务包")
@Setter
@Getter
@ToString
public class TenantServicePackageDto implements IOperator {

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "租户服务包ID")
    protected Long id;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "租户ID")
    protected Long tenantId;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "产品服务包ID")
    protected Long servicePackageId;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "状态，1有效，0无效")
    protected Integer status;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "软删除状态，1已删除，0未删除")
    protected Integer deleted;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "创建人ID")
    protected String createrId;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView({View.List.class, View.Page.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    protected Date createTime;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "更新人ID")
    protected String updaterId;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "更新人姓名")
    protected String updaterName;

    @JsonView({View.List.class, View.Page.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "更新时间")
    protected Date updateTime;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "备注")
    protected String comments;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "租户code")
    protected String tenantCode;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "应用名称")
    protected String appName;

    @ApiModelProperty("服务包Id集合")
    @JsonView({View.List.class, View.Page.class})
    protected List<Long> servicePackageIds;

    @ApiModelProperty("服务包名称集合")
    @JsonView({View.List.class, View.Page.class})
    protected List<String> servicePackageNames;

    @ApiModelProperty("服务包Code集合")
    @JsonView({View.List.class, View.Page.class})
    protected List<String> servicePackageCodes;

    @ApiModelProperty("服务包总数")
    @JsonView({View.List.class, View.Page.class})
    private Long total;
}
