package com.xforceplus.domain.user;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import com.xforceplus.utils.DateUtils;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;


/**
 * @author geewit
 */
@ApiModel(value = "用户")
@Setter
@Getter
public class UserDto<O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> extends AuthorizedUser<O, R> implements IOperator {
    @ApiModelProperty(value = "用户编码", notes = "预留给业务系统使用")
    @JsonView(View.class)
    protected String userNumber;

    @ApiModelProperty(value = "联系电话")
    @JsonView(View.class)
    protected String userPhone;

    @ApiModelProperty(value = "性别")
    @JsonView(View.class)
    protected Integer userSex;

    @JsonView(View.class)
    protected String userEmailAddr;

    @JsonView(View.class)
    protected String userIdCard;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView(View.class)
    protected Date userPeriodTime;

    @JsonView(View.class)
    protected String userWorkTel;

    @JsonView(View.class)
    protected Integer activeStatus;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonView({View.class})
    @ApiModelProperty(value = "过期日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date expiredDate;

    @JsonView(View.class)
    protected String contactAddr;

    @ApiModelProperty("业务扩展属性")
    @JsonView(View.class)
    protected String businessExtensionAttribute;
    @ApiModelProperty(value = "发票类型", notes = "c：普票；s：专票；cs：专票和普票 ce：普电票")
    @JsonView(View.class)
    protected String invoiceType;
    @ApiModelProperty(value = "打印设备", notes = "多个打印设备值用','隔开")
    @JsonView(View.class)
    protected String printingEquipment;
    @ApiModelProperty(value = "开票终端", notes = "多个开票终端用','分隔开")
    @JsonView(View.class)
    protected String ticketOpeningTerminal;

    @ApiModelProperty("账号信息")
    @JsonView(View.class)
    protected A account;

    @ApiModelProperty("过滤组织parentIds集合")
    protected Set<String> filterParentIdSet;

    @ApiModelProperty(value = "来源类型", notes = " 1 内部（默认） 2 外部 ")
    @JsonView(View.class)
    protected Integer sourceType;

    @ApiModelProperty(value = "组织身份", notes = "1: 普通, 2: 管理员")
    @JsonView(View.class)
    protected Integer orgRelType;

    @JsonView({View.Tree.class, View.List.class})
    @ApiModelProperty(value = "当前用户是否是指定组织节点管理员")
    protected Boolean isOrgAdmin;

    @ApiModelProperty(value = "是否是最后一个租户管理员")
    @JsonView({UserView.UserInfo.class, View.Tree.class, View.List.class})
    protected Boolean isLastTenantAdmin;

    @ApiModelProperty(value = "是否租户管理员")
    @JsonView({UserView.UserInfo.class, View.Tree.class, View.List.class})
    protected Boolean isTenantAdmin;

    @ApiModelProperty(value = "account.username")
    @JsonView(View.class)
    protected String accountUserName;

    @ApiModelProperty(value = "account.email")
    @JsonView(View.class)
    protected String accountEmail;

    @ApiModelProperty(value = "account.telPhone")
    @JsonView(View.class)
    protected String accountTelPhone;

    public void setBusinessExtensionAttribute(String businessExtensionAttribute) {
        this.businessExtensionAttribute = ObjectUtils.defaultIfNull(businessExtensionAttribute, StringUtils.EMPTY);
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = ObjectUtils.defaultIfNull(invoiceType, StringUtils.EMPTY);
    }

    public void setPrintingEquipment(String printingEquipment) {
        this.printingEquipment = ObjectUtils.defaultIfNull(printingEquipment, StringUtils.EMPTY);
    }

    public void setTicketOpeningTerminal(String ticketOpeningTerminal) {
        this.ticketOpeningTerminal = ObjectUtils.defaultIfNull(ticketOpeningTerminal, StringUtils.EMPTY);
    }

    @SuppressWarnings("all")
    @Override
    @JsonView(UserView.UserInfo.class)
    public Set<O> getOrgs() {
        return currentOrgs;
    }

    @Override
    @JsonView(UserView.UserInfo.class)
    public Set<O> getCurrentOrgs() {
        return currentOrgs;
    }

    @JsonView(View.class)
    public A getAccount() {
        return account;
    }

    @ApiModelProperty("是否过期")
    @JsonView(View.class)
    public boolean isExpired() {
        if (this.expiredDate == null) {
            return false;
        }
        return DateUtils.beforeNow(this.expiredDate, false);
    }
}
