package com.xforceplus.constants;


import io.geewit.core.utils.enums.Name;
import io.geewit.core.utils.enums.Value;

public enum AccountLoginTypeEnum implements Name, Value<Integer> {
    PHONE(0,"手机"),
    EMAIL(1,"邮箱"),
    DOMAIN(2,"域账号");

    private final int value;
    private final String name;

    AccountLoginTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Integer value() {
        return value;
    }
}