package com.xforceplus.constants;

/**
 * 常用正则
 */
public class RegPattern {
    /**
     * 税号，15，16或者18位字母数字组成
     */
    public static final String TAX_NUM = "^[a-zA-Z0-9]{15,18}|^[a-zA-Z0-9]{20}";

    /**
     * sso名称：长度2-32位，允许中英文字符、数字，以及符号(_)(-) (.)
     */
    public static  final  String SSO_NAME = "^[\u4e00-\u9fa5a-zA-Z0-9_\\-.]{2,32}$";

    /**
     * URL可带参数(不支持ip+端口)
     */
    public static final String URL = "^https?://[\\w-]+(\\.[\\w-]+)+([\\w-./?%&=]*)([?&].*=https?://[\\w-]+(\\.[\\w-]+)+([\\w-./?%&=]*)+)*$";


    public interface Role{
        String ROLE_CODE = "^[\\w\\u4e00-\\u9fa5@#()-]{1,64}";
        String ROLE_CODE_MSG = "支持使用大小写英文字符、中文字符、中划线\"-\"、下划线\"_\"、\"@\"、井号\"#\"、英文括号\"(\"、\")，最大长度64位";
    }

}
