package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.tenant.security.core.domain.IOperator;

import java.util.Date;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author HWT
 * @since 2021/8/27 14:01
 */
@Setter
@Getter
public class BaseDto implements IOperator {

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    @Schema(description = "创建人id")
    protected String createrId;

    /**
     * 创建人名称
     */
    @Schema(description = "创建人名称")
    protected String createrName;

    /**
     * 更新人id
     */
    @Schema(description = "更新人id")
    protected String updaterId;

    /**
     * 更新人名称
     */
    @Schema(description = "更新人名称")
    protected String updaterName;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

}
