package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * 组织扩展
 * @author geewit
 */
@Setter
@Getter
@ToString
public class ExtensionDto {

    /**
     * 扩展字段key
     */
    @Schema(description = "扩展字段key")
    @JsonView(View.class)
    protected String extensionKey;

    /**
     * 扩展字段value
     */
    @Schema(description = "扩展字段value")
    @JsonView(View.class)
    protected String extensionValue;

    /**
     * 扩展字段描述
     */
    @JsonView(View.class)
    protected String description;

    /**
     * 状态 1:启用, 2:作废
     */
    @Schema(description = "状态 1:启用, 2:作废")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

}
