package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;

import java.util.Collection;
import java.util.Objects;

/**
 * reactjs tree
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
@ToString
public class TreeNode {
    /**
     * type 产品服务包，功能集、资源码
     */
    @JsonIgnore
    private String type;
    /**
     * key
     */
    private Long key;
    /**
     * id
     */
    @JsonIgnore
    private String id;
    /**
     * title
     */
    private String title;
    /**
     * pid
     */
    @JsonIgnore
    private Long pid;
    /**
     * parentKey
     */
    @JsonIgnore
    private String parentKey;
    /**
     * children
     */
    private Collection<TreeNode> children;
    /**
     * 资源路径
     */
    @JsonIgnore
    private String path;

    /**
     * 是否有权限
     */
    private boolean hasPermission;

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()){
            return false;
        }
        TreeNode that = (TreeNode) obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key);
    }
}
