package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.account.view.Password;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.token.domain.view.RedisView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * 帐号
 * @author geewit
 */
@Schema(name = "帐号")
@FieldNameConstants
@Setter
@Getter
public class AccountDto implements IOperator {

    /**
     * 帐号id
     */
    @Schema(description = "帐号id")
    @JsonView({View.class, RedisView.class})
    protected Long accountId;

    /**
     * 登录email
     */
    @Schema(description = "登录email")
    @JsonView({View.class, RedisView.class})
    protected String email;

    /**
     * 帐号密码
     */
    @Schema(description = "帐号密码")
    @JsonView({Password.class, RedisView.class})
    protected String password;

    /**
     * 登录手机
     */
    @Schema(description = "登录手机")
    @JsonView({View.class, RedisView.class})
    protected String telPhone;

    /**
     * 状态  1：启用 0：禁用
     */
    @Schema(description = "状态  1：启用 0：禁用")
    @JsonView({View.class, RedisView.class})
    protected Integer status;

    /**
     * username
     */
    @Schema(description = "username")
    @JsonView({View.class, RedisView.class})
    protected String username;

    @JsonView({RedisView.class})
    protected String salt;

    /**
     * 创建人id
     */
    @Schema(description = "创建人id")
    @JsonView({RedisView.class})
    protected String createrId;

    /**
     * 创建人名称
     */
    @JsonView({RedisView.class})
    @Schema(description = "创建人名称")
    protected String createrName;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 更新人id
     */
    @Schema(description = "更新人id")
    @JsonView({RedisView.class})
    protected String updaterId;

    /**
     * 更新人名称
     */
    @Schema(description = "更新人名称")
    @JsonView({RedisView.class})
    protected String updaterName;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 是否需要改密码
     */
    @Schema(description = "是否需要改密码")
    @JsonView({View.class, RedisView.class})
    protected Boolean changePasswordFlag;

    /**
     * 密码更新时间 pwdLastUpdateTime 不可以加格式化，老的sdk会解析失败）
     */
    @Schema(description = "密码更新时间")
    @JsonView({View.class, RedisView.class})
    protected Date pwdLastUpdateTime;

    /**
     * 最后修改密码时间（代替pwdLastUpdateTime字段）
     *
     */
    @Schema(description = "最后修改密码时间")
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date pwdLastModifyTime;

    /**
     * 二次验证标识
     */
    @Schema(description = "二次验证标识")
    @JsonView({View.class, RedisView.class})
    protected Boolean doubleAuthFlag;

    /**
     * 是否需要绑定手机或者邮箱
     */
    @Schema(description = "是否需要绑定手机或者邮箱")
    @JsonView({View.class, RedisView.class})
    protected Boolean bindAuthFlag;

    /**
     * 密码长度
     */
    @Schema(description = "密码长度")
    @JsonView({View.class, RedisView.class})
    protected Integer passwdLength;

    public Date getPwdLastModifyTime() {
        return pwdLastUpdateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountDto that = (AccountDto) o;
        return Objects.equals(this.accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.accountId);
    }
}
