package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.ICreater;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

@Schema(name = "帐号")
@FieldNameConstants
@Setter
@Getter
public class AccountLoginDto implements ICreater {

    /**
     * id
     */
    @Schema(description = "登录账号")
    @JsonView(View.class)
    protected Long accountLoginId;


    /**
     * 登录账号
     */
    @Schema(description = "登录账号")
    @JsonView(View.class)
    protected String username;

    /**
     * 帐号id
     */
    @Schema(description = "帐号id")
    @JsonView(View.class)
    protected Long accountId;

    /**
     * 账号类型
     */
    @Schema(description = "type,0:email  1:tel_phone 2:domain")
    @JsonView(View.class)
    protected Integer type;


    /**
     * 创建人id
     */
    @Schema(description = "创建人id")
    protected String createrId;

    /**
     * 创建人名称
     */
    @Schema(description = "创建人名称")
    protected String createrName;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountLoginDto that = (AccountLoginDto) o;
        return Objects.equals(this.accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.username);
    }

}