package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

import java.io.Serializable;
import java.util.Date;

/**
 * 帐号平台关联表
 * @author geewit
 */
@Schema(name = "帐号平台关联表Dto")
@FieldNameConstants
@Setter
@Getter
public class AccountPlatformRelDto implements Serializable {
    /**
     * id
     */
    @Schema(description = "id")
    protected Long id;

    /**
     * 帐号id
     */
    @Schema(description = "帐号id")
    protected Long accountId;

    /**
     * 平台类型 1 微信
     */
    @Schema(description = "平台类型 1 微信")
    protected Integer platformType;

    /**
     * 平台id
     */
    @Schema(description = "平台id")
    protected String platformId;

    /**
     * 平台应用Id
     */
    @Schema(description = "平台应用Id")
    protected String platformAppId;

    /**
     * 状态  1:启用 0:禁用
     */
    @Schema(description = "状态  1:启用 0:禁用")
    protected Integer status;

    /**
     * 生效时间
     */
    @Schema(description = "生效时间")
    @JsonView({View.Info.class})
    protected Date enableTime;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonView({View.Info.class})
    protected Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonView({View.Info.class})
    protected Date updateTime;

    /**
     * 用户ID
     */
    @Schema(description = "用户ID")
    @JsonView({View.Info.class})
    protected String userId;

    /**
     * 应用类型
     */
    @Schema(description = "应用类型")
    @JsonView({View.Info.class})
    protected String appType;

    /**
     * 扩展字段1
     */
    @Schema(description = "扩展字段1")
    @JsonView({View.Info.class})
    protected String ext1;

    /**
     * 扩展字段2
     */
    @Schema(description = "扩展字段2")
    @JsonView({View.Info.class})
    protected String ext2;

    /**
     * 扩展字段3
     */
    @Schema(description = "扩展字段3")
    @JsonView({View.Info.class})
    protected String ext3;

}
