package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.BaseDto;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

/**
 * 账户隐私签署
 * @author HWT
 * @since  2021/8/27 9:35
 */
@Schema(name = "账户隐私签署Dto")
@FieldNameConstants
@Setter
@Getter
public class AccountPrivacyDto extends BaseDto {

  /**
   * id
   */
  @Schema(description = "id")
  protected Long id;

  /**
   * 帐号id
   */
  @Schema(description = "帐号id")
  @JsonView(View.class)
  protected Long accountId;

  /**
   * 网站地址
   */
  @Schema(description = "网站地址")
  @JsonView(View.class)
  protected String webSite;

  /**
   * 隐私版本号
   */
  @Schema(description = "隐私版本号")
  @JsonView(View.class)
  protected String version;

}
